/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyChangedListener;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;

public class VWTaskTabbedPane
extends JTabbedPane
implements VWTaskPropertyChangedListener {
    private EventListenerList m_listenerList = new EventListenerList();

    public VWTaskTabbedPane() {
        VWTaskUtil.updateComponentOrientation(this);
    }

    public void validateProperties() throws VWException {
        Component c = null;
        for (int i = 0; i < this.getTabCount(); ++i) {
            try {
                c = this.getComponentAt(i);
                if (c instanceof JScrollPane) {
                    c = ((JScrollPane)c).getViewport().getView();
                }
                if (c instanceof VWToolbarBorder) {
                    c = ((VWToolbarBorder)c).getClientPanel();
                }
                if (!(c instanceof VWTaskTabPanel)) continue;
                ((VWTaskTabPanel)c).validateTextFields();
                continue;
            }
            catch (VWException ex) {
                if (VWTaskTabPanel.getSetFocusOnFailedValidation()) {
                    this.setSelectedIndex(i);
                }
                throw ex;
            }
        }
    }

    public void validateTextField(JTextComponent field) throws VWException {
        VWTaskTabbedPane.validateTextField(this, field);
    }

    private static void validateTextField(Container container, JTextComponent field) throws VWException {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (c.equals(field)) {
                if (!(container instanceof VWTaskTabPanel)) break;
                ((VWTaskTabPanel)container).validateTextField(field);
                break;
            }
            if (!(c instanceof Container)) continue;
            try {
                VWTaskTabbedPane.validateTextField((Container)c, field);
                continue;
            }
            catch (VWException e) {
                if (container instanceof JTabbedPane) {
                    JTabbedPane tabPanel = (JTabbedPane)container;
                    tabPanel.setSelectedIndex(tabPanel.indexOfComponent(c));
                }
                throw e;
            }
        }
    }

    private static boolean hasComponent(Container container, Component c) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].equals(c)) continue;
            return true;
        }
        return false;
    }

    public void displayHelp() {
        VWTaskTabPanel tab = null;
        Component c = this.getSelectedComponent();
        if (c instanceof JScrollPane) {
            c = ((JScrollPane)c).getViewport().getView();
        }
        if (c instanceof VWToolbarBorder) {
            c = ((VWToolbarBorder)c).getClientPanel();
        }
        if (c instanceof VWTaskTabPanel) {
            tab = (VWTaskTabPanel)c;
        }
        if (tab != null && tab.getHelpPage() != null) {
            VWHelp.displayPage(tab.getHelpPage());
        } else {
            VWTaskCore.getInstance().displayHelp();
        }
    }

    public void addTab(String title, Component panel) {
        this.addTab(title, panel, true);
    }

    public void addTab(String title, Component panel, boolean autoScrollPane) {
        JPanel clientPanel;
        if (!(panel instanceof JScrollPane) && autoScrollPane) {
            JScrollPane sPane = new JScrollPane(panel, 20, 31);
            sPane.setBorder(null);
            super.addTab(title, sPane);
        } else {
            super.addTab(title, panel);
        }
        if (panel instanceof VWTaskTabPanel) {
            ((VWTaskTabPanel)panel).addVWTaskPropertyChangedListener(this);
        } else if (panel instanceof VWToolbarBorder && (clientPanel = ((VWToolbarBorder)panel).getClientPanel()) instanceof VWTaskTabPanel) {
            ((VWTaskTabPanel)clientPanel).addVWTaskPropertyChangedListener(this);
        }
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            index = 0;
        }
        super.setSelectedIndex(index);
    }

    public int getTabIndexForComponent(Component c) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component tabComponent = this.getComponentAt(i);
            if (tabComponent.equals(c)) {
                return i;
            }
            if (!(tabComponent instanceof Container) || !this.containerContainsComponent((Container)tabComponent, c)) continue;
            return i;
        }
        return -1;
    }

    private boolean containerContainsComponent(Container container, Component component) {
        boolean found = false;
        Component[] components = container.getComponents();
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                if (components[i].equals(component)) {
                    found = true;
                    break;
                }
                if (!(components[i] instanceof Container) || !this.containerContainsComponent((Container)components[i], component)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void addVWTaskPropertyChangedListener(VWTaskPropertyChangedListener listener) {
        this.m_listenerList.add(VWTaskPropertyChangedListener.class, listener);
    }

    public void removeVWTaskPropertyChangedListener(VWTaskPropertyChangedListener listener) {
        this.m_listenerList.remove(VWTaskPropertyChangedListener.class, listener);
    }

    public void taskPropertyChanged(VWTaskPropertyChangedEvent evt) {
        this.fireVWTaskPropertyChangedEvent(evt);
    }

    private void fireVWTaskPropertyChangedEvent(VWTaskPropertyChangedEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != VWTaskPropertyChangedListener.class) continue;
            ((VWTaskPropertyChangedListener)listeners[i + 1]).taskPropertyChanged(event);
        }
    }
}

